#include "h/p33FJ64GP802.h"
#include "h/spi.h"
#include "h/GenericTypeDefs.h"
#include "h/HardwareProfile.h"
#include "h/XEEPROM.h"
#include "h/sd.h"

/* Initialize and enable the SPI module */
void InitSPI(int speed)
{
	// Initialise the SPI System
	SPI1CON1=speed;
	SPI1CON1bits.SMP=0;
	SPI1CON1bits.CKP=0;			// clock Polarity 0: idle low, active high 1: idle high, active low
	SPI1CON1bits.CKE=1;			// clock edge selection
	SPI1CON1bits.MSTEN=1;		// enable Master Mode
	SPI1STATbits.SPIROV=0;
	ENC_SPI_IF=0;
	SPI1STATbits.SPIEN=1;
}

BYTE WriteSPI(BYTE x)
{
//	SDCS=1;
//	SPI1CON1=SPI_SPEED;
//	SPI1CON1bits.SMP=0;
//	SPI1CON1bits.CKP=0;			// clock Polarity 0: idle low, active high 1: idle high, active low
//	SPI1CON1bits.CKE=1;			// clock edge selection
//	SPI1CON1bits.MSTEN=1;		// enable Master Mode
//	SPI1STATbits.SPIROV=0;
//	SPI1STATbits.SPIEN=1;
	SDCS=0;
	SPI1BUF=x;
	while(SPI1STATbits.SPITBF);
	while(SPI1STATbits.SPIRBF==0);
	x=SPI1BUF;
	SDCS=1;
	ENC_SPI_IF=0;
	return x;
}

BYTE WriteSPIWithoutSS(BYTE x)
{
	SPI1BUF=x;
	while(SPI1STATbits.SPITBF);
	while(SPI1STATbits.SPIRBF==0);
	x=SPI1BUF;
	ENC_SPI_IF=0;
	return x;
}
